
import gurobi

def solve_wedding_cake_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    V = model.addVar(lb=0, name="Vanilla_cake_mix")  # in kg
    C = model.addVar(lb=0, name="Chocolate_cake_mix")  # in kg

    # Objective function: minimize cost
    model.setObjective(10 * V + 15 * C, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.03 * V + 0.02 * C >= 0.3, name="Leavening_Agent_Requirement")
    model.addConstr(0.55 * V + 0.43 * C >= 10, name="Flour_Requirement")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal amount of Vanilla cake mix: {V.varValue} kg")
        print(f"Optimal amount of Chocolate cake mix: {C.varValue} kg")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

if __name__ == "__main__":
    solve_wedding_cake_problem()
