
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("snack_mix")

# Create variables
x = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x") # Snack Mix A
y = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="y") # Snack Mix B

# Set objective function
model.setObjective(1.00*x + 1.20*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(20*x + 10*y >= 90, "cashew_constraint")
model.addConstr(30*x + 45*y >= 80, "peanut_constraint")
model.addConstr(x <= 12, "snack_a_limit")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal:.2f}")
    print(f"Snack Mix A: {x.x:.2f}")
    print(f"Snack Mix B: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

