
from gurobipy import *

# Create a model
m = Model("Snack_Mix_Optimization")

# Decision variables
x_A = m.addVar(lb=0, name="snack_mix_A")
x_B = m.addVar(lb=0, name="snack_mix_B")

# Objective function: Minimize cost
m.setObjective(1*x_A + 1.20*x_B, GRB.MINIMIZE)

# Constraints
m.addConstr(20*x_A + 10*x_B >= 90, "cashew_constraint")
m.addConstr(30*x_A + 45*x_B >= 80, "peanut_constraint")
m.addConstr(x_A <= 12, "snack_mix_A_limit")

# Optimize
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x_A.varName} = {x_A.x}, {x_B.varName} = {x_B.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
