
import gurobi

def solve_snack_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_A = model.addVar(lb=0, name="x_A")  # Number of snack mix A units
    x_B = model.addVar(lb=0, name="x_B")  # Number of snack mix B units

    # Objective function: Minimize cost
    model.setObjective(1.00 * x_A + 1.20 * x_B, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20 * x_A + 10 * x_B >= 90, name="cashews_requirement")
    model.addConstr(30 * x_A + 45 * x_B >= 80, name="peanuts_requirement")
    model.addConstr(x_A <= 12, name="limit_on_snack_mix_A")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x_A = {x_A.varValue}, x_B = {x_B.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_snack_mix_problem()
