
import gurobipy as gp

# Create a new model
m = gp.Model("smoothie_optimization")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="peanut_butter_smoothies")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="almond_butter_smoothies")

# Set objective function
m.setObjective(5*x + 4*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 2*y <= 50, "almond_milk_constraint")
m.addConstr(x + 1.5*y <= 40, "protein_powder_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Peanut Butter Smoothies: {x.x}")
    print(f"Almond Butter Smoothies: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

