
from gurobipy import *

# Create a new model
m = Model("Smoothie_Optimization")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Peanut_Butter_Smoothies")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Almond_Butter_Smoothies")

# Define the objective function
m.setObjective(5*x + 4*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 2*y <= 50, name="Almond_Milk_Constraint")
m.addConstr(x + 1.5*y <= 40, name="Protein_Powder_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peanut Butter Smoothies: {x.x}")
    print(f"Almond Butter Smoothies: {y.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")

