
import gurobi

def solve_smoothie_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="peanut_butter_smoothies")
    y = model.addVar(lb=0, name="almond_butter_smoothies")

    # Define the objective function
    model.setObjective(5 * x + 4 * y, gurobi.GRB.MAXIMIZE)

    # Add the almond milk constraint
    model.addConstr(3 * x + 2 * y <= 50, name="almond_milk_constraint")

    # Add the protein powder constraint
    model.addConstr(x + 1.5 * y <= 40, name="protein_powder_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${5 * x.varValue + 4 * y.varValue:.2f}")
    else:
        print("No optimal solution found")

# Run the function
solve_smoothie_problem()
