
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("minimize_wage_bill")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="international_employees")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="local_employees")

# Set objective
m.setObjective(500*x + 1200*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(x + y >= 50, "total_employees")
m.addConstr(y >= 12, "min_local_employees")
m.addConstr(y >= (1/3)*x, "local_international_ratio")
m.addConstr(500*x + 1200*y <= 40000, "max_wage_bill")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {m.objVal}")
    print(f"International employees: {x.x}")
    print(f"Local employees: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

