
from gurobipy import *

# Create a model
m = Model("Wage_Bill_Optimization")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="International_Employees")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Local_Employees")

# Objective function: Minimize the total wage bill
m.setObjective(500*x + 1200*y, GRB.MINIMIZE)

# Constraints
m.addConstr(x + y >= 50, "Total_Employees")
m.addConstr(y >= 12, "Minimum_Local_Employees")
m.addConstr(y >= (1/3)*x, "Local_to_International_Ratio")
m.addConstr(500*x + 1200*y <= 40000, "Wage_Bill_Limit")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"International Employees: {x.x}")
    print(f"Local Employees: {y.x}")
    print(f"Total Wage Bill: ${500*x.x + 1200*y.x:.2f}")
else:
    print("No optimal solution found")
