
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, name="international_employees", vtype=gurobi.GRB.INTEGER)
    y = model.addVar(lb=0, name="local_employees", vtype=gurobi.GRB.INTEGER)

    # Objective: Minimize the total weekly wage bill
    model.setObjective(500*x + 1200*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x + y >= 50, name="total_employees")
    model.addConstr(y >= 12, name="local_employees_requirement")
    model.addConstr(y >= x/3, name="local_vs_international_ratio")
    model.addConstr(500*x + 1200*y <= 40000, name="weekly_wage_bill")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"International Employees: {x.varValue}")
        print(f"Local Employees: {y.varValue}")
        print(f"Minimum Weekly Wage Bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
