
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Perfume_Mixture")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="French_Perfume")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Spanish_Perfume")

# Set objective function
m.setObjective(50*x + 45*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x + 30*y >= 150, "Flower_Scent")
m.addConstr(50*x + 40*y >= 60, "Fruit_Scent")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"French Perfume bottles: {x.x}")
    print(f"Spanish Perfume bottles: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

