
from gurobipy import *

# Create a new model
m = Model("Perfume_Mixture")

# Define the decision variables
x_F = m.addVar(vtype=GRB.CONTINUOUS, name="French_Perfume", lb=0)
x_S = m.addVar(vtype=GRB.CONTINUOUS, name="Spanish_Perfume", lb=0)

# Set the objective function
m.setObjective(50*x_F + 45*x_S, GRB.MINIMIZE)

# Add constraints
m.addConstr(20*x_F + 30*x_S >= 150, name="Flower_Scent_Constraint")
m.addConstr(50*x_F + 40*x_S >= 60, name="Fruit_Scent_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"French Perfume: {x_F.x}")
    print(f"Spanish Perfume: {x_S.x}")
    print(f"Total Cost: ${50*x_F.x + 45*x_S.x:.2f}")
else:
    print("No optimal solution found")
