
import gurobi

def solve_perfume_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="French_perfume", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="Spanish_perfume", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Minimize cost
    model.setObjective(50*x + 45*y, sense=gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(20*x + 30*y >= 150, name="flower_scent_req")
    model.addConstr(50*x + 40*y >= 60, name="fruit_scent_req")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Cost: ${model.objval:.2f}")
        print(f"French perfume: {x.varValue:.2f} bottles")
        print(f"Spanish perfume: {y.varValue:.2f} bottles")
    else:
        print("No optimal solution found.")

# Run the function
solve_perfume_problem()
