
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(lb=0, name="carrots") # Acres of carrots
y = m.addVar(lb=0, name="green_peas") # Acres of green peas

# Set objective function
m.setObjective(250*x + 340*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "land_constraint")
m.addConstr(0.7*x + 0.4*y <= 135, "watering_constraint")
m.addConstr(1.2*x + 1.5*y <= 110, "spraying_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x:.2f} acres of carrots")
    print(f"Plant {y.x:.2f} acres of green peas")
    print(f"Maximum Profit: ${m.objVal:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

