
from gurobipy import *

# Create a new model
m = Model("Farmland_Optimization")

# Define variables
x = m.addVar(lb=0, name="carrots_acres")
y = m.addVar(lb=0, name="peas_acres")

# Objective function: Maximize profit
m.setObjective(250*x + 340*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 100, "land_constraint")
m.addConstr(0.7*x + 0.4*y <= 135, "watering_days")
m.addConstr(1.2*x + 1.5*y <= 110, "spraying_days")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Carrots acres: {x.x}")
    print(f"Green peas acres: {y.x}")
    print(f"Max Profit: ${250*x.x + 340*y.x:.2f}")
else:
    print("No optimal solution found")
