
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, name="carrots")  # acres of carrots
y = m.addVar(lb=0, name="green_peas")  # acres of green peas

# Define the objective function
m.setObjective(250*x + 340*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(x + y <= 100, name="land")
m.addConstr(0.7*x + 0.4*y <= 135, name="watering")
m.addConstr(1.2*x + 1.5*y <= 110, name="spraying")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution:")
    print(f"Acres of carrots: {x.varValue:.2f}")
    print(f"Acres of green peas: {y.varValue:.2f}")
    print(f"Max profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
