
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("desk_production")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="regular_desks")
y = m.addVar(vtype=GRB.CONTINUOUS, name="standing_desks")

# Set objective function
m.setObjective(200*x + 300*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 15*y <= 4000, "wood_constraint")
m.addConstr(10*x + 20*y <= 1500, "packaging_constraint")
m.addConstr(x >= 0, "non_negativity_x")
m.addConstr(y >= 0, "non_negativity_y")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Regular Desks: {x.x}")
    print(f"Standing Desks: {y.x}")
    print(f"Optimal Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

