
from gurobipy import *

# Create a model
m = Model("Desk_Production")

# Define variables
x = m.addVar(name="regular_desks", vtype=GRB.INTEGER, lb=0)
y = m.addVar(name="standing_desks", vtype=GRB.INTEGER, lb=0)

# Set objective function
m.setObjective(200*x + 300*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 15*y <= 4000, name="wood_constraint")
m.addConstr(10*x + 20*y <= 1500, name="packaging_time_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x.x} regular desks and {y.x} standing desks.")
else:
    print("No optimal solution found.")
