
import gurobi

def solve_desk_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="Regular_Desks")
    S = model.addVar(vtype=gurobi.GRB.CONTINUOUS, name="Standing_Desks")

    # Objective function: Maximize profit
    model.setObjective(200*R + 300*S, gurobi.GRB.MAXIMIZE)

    # Wood constraint
    model.addConstr(20*R + 15*S <= 4000, name="Wood_Constraint")

    # Packaging time constraint
    model.addConstr(10*R + 20*S <= 1500, name="Packaging_Time_Constraint")

    # Non-negativity constraints
    model.addConstr(R >= 0, name="Non_Negativity_Regular")
    model.addConstr(S >= 0, name="Non_Negativity_Standings")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Number of regular desks: {R.varValue}, Number of standing desks: {S.varValue}")
        print(f"Maximum profit: ${200*R.varValue + 300*S.varValue}")
    else:
        print("No optimal solution found.")

solve_desk_production_problem()
