
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x = m.addVar(nonnegative=True, name="Special_Formula")
y = m.addVar(nonnegative=True, name="One_Daily")

# Set objective function
m.setObjective(0.5 * x + 0.2 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * x + 3 * y >= 25, "Vitamin_A")
m.addConstr(5 * x + 7 * y >= 40, "Vitamin_B")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of Special Formula capsules: {x.x:.2f}")
    print(f"Number of One Daily capsules: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

