
from gurobipy import *

# Create a new model
m = Model("Vitamin_Purchase")

# Add variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="Special Formula", lb=0)
y = m.addVar(vtype=GRB.CONTINUOUS, name="One Daily", lb=0)

# Set the objective function
m.setObjective(0.50*x + 0.20*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x + 3*y >= 25, "Vitamin_A")
m.addConstr(5*x + 7*y >= 40, "Vitamin_B")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x.x} Special Formula capsules")
    print(f"Buy {y.x} One Daily capsules")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")

