
import gurobi as grb

def solve_vitamin_problem():
    model = grb.Model()

    x = model.addVar(name="Special_Formula", obj=0.50, vtype=grb.GRB.INTEGER)
    y = model.addVar(name="One_Daily", obj=0.20, vtype=grb.GRB.INTEGER)

    model.addConstr(x * 4 + y * 3 >= 25, name="Vitamin_A")
    model.addConstr(x * 5 + y * 7 >= 40, name="Vitamin_B")

    x.lb = 0
    y.lb = 0

    model.optimize()

    if model.status == grb.GRB.OPTIMAL:
        print(f"Optimal solution: Special Formula = {x.varValue}, One Daily = {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_vitamin_problem()
