
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hot_dog_stand")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # Regular hot dogs
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # Premium hot dogs

# Set objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 80, "demand_regular")
m.addConstr(x2 <= 70, "demand_premium")
m.addConstr(x1 + x2 <= 120, "total_supply")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Number of regular hot dogs (x1): {x1.x}")
    print(f"Number of premium hot dogs (x2): {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

