
from gurobipy import *

# Create a model
m = Model("Hot_Dog_Stand")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="regular_hot_dogs")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="premium_hot_dogs")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 <= 80, "regular_demand")
m.addConstr(x2 <= 70, "premium_demand")
m.addConstr(x1 + x2 <= 120, "total_supply")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Regular Hot Dogs = {x1.x}, Premium Hot Dogs = {x2.x}")
    print(f"Total Profit: ${3*x1.x + 5*x2.x:.2f}")
else:
    print("No optimal solution found")

