
import gurobi

def solve_hot_dog_stand_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(lb=0, name="regular_hot_dogs")
    x2 = model.addVar(lb=0, name="premium_hot_dogs")

    # Objective function: Maximize profit
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Demand constraints
    model.addConstr(x1 <= 80, name="regular_demand_constraint")
    model.addConstr(x2 <= 70, name="premium_demand_constraint")

    # Supply constraint
    model.addConstr(x1 + x2 <= 120, name="supply_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Regular Hot Dogs: {x1.varValue}")
        print(f"Premium Hot Dogs: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible or unbounded.")

solve_hot_dog_stand_problem()
