
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("TicketOptimization")

# Create decision variables
x = model.addVar(lb=0, vtype=GRB.INTEGER, name="all_inclusive")
y = model.addVar(lb=0, vtype=GRB.INTEGER, name="regular")

# Set objective function
model.setObjective(50*x + 20*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x + y <= 500, "total_tickets")
model.addConstr(x >= 100, "min_all_inclusive")
model.addConstr(y >= 3*x, "regular_preference")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of all-inclusive tickets: {x.x}")
    print(f"Number of regular tickets: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
else:
    print("No solution found.")

