
from gurobipy import *

# Create a model
m = Model("Amusement_Park_Ticket_Sales")

# Define variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="all_inclusive_tickets")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_tickets")

# Objective function: Maximize profit
m.setObjective(50*x + 20*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y <= 500, "capacity_constraint")  # Total tickets cannot exceed 500
m.addConstr(x >= 100, "all_inclusive_reservation")  # At least 100 all-inclusive tickets
m.addConstr(y >= 3*x, "preference_constraint")  # Preference for regular tickets

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of all-inclusive tickets: {x.x}")
    print(f"Number of regular tickets: {y.x}")
    print(f"Maximum profit: ${50*x.x + 20*y.x:.2f}")
else:
    print("No optimal solution found. The model is infeasible.")
