
import gurobipy as gp

# Create a new model
m = gp.Model("Ticket_Sales")

# Define variables
x = m.addVar(name="all_inclusive_tickets", lb=0, vtype=gp.GRB.INTEGER)
y = m.addVar(name="regular_tickets", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(50*x + 20*y, sense=gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x + y == 500, name="capacity_constraint")
m.addConstr(x >= 100, name="min_all_inclusive")
m.addConstr(y >= 3*x, name="preference_regular")

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: All-inclusive tickets = {x.varValue}, Regular tickets = {y.varValue}")
    print(f"Max Profit: ${50*x.varValue + 20*y.varValue}")
else:
    print("The model is infeasible.")
