
import gurobipy as gp

# Create a new model
model = gp.Model("T-Shirt Production")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blue_tshirts")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dark_blue_tshirts")

# Set objective function
model.setObjective(10 * x + 15 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * x + 5 * y <= 1000, "dye_constraint")
model.addConstr(5 * x + 4 * y <= 1200, "water_constraint")
model.addConstr(30 * x + 25 * y <= 8000, "worker_minutes_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of blue t-shirts: {x.x}")
    print(f"Number of dark blue t-shirts: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

