
from gurobipy import *

# Create a model
m = Model("Clothing_Company_Profit_Optimization")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="blue_tshirts")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="dark_blue_tshirts")

# Objective function: Maximize profit
m.setObjective(10*x + 15*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(3*x + 5*y <= 1000, "dye_constraint")
m.addConstr(5*x + 4*y <= 1200, "water_constraint")
m.addConstr(30*x + 25*y <= 8000, "worker_minutes_constraint")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blue T-Shirts: {x.x}")
    print(f"Dark Blue T-Shirts: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found.")
