
import gurobipy as gp

# Create a new model
model = gp.Model("T-Shirt_Production")

# Define the decision variables
B = model.addVar(lb=0, name="Blue_T-Shirts")
D = model.addVar(lb=0, name="Dark_Blue_T-Shirts")

# Define the objective function
model.setObjective(10*B + 15*D, gp.GRB.MAXIMIZE)

# Add the constraints
model.addConstr(3*B + 5*D <= 1000, name="Dye_Constraint")
model.addConstr(5*B + 4*D <= 1200, name="Water_Constraint")
model.addConstr(30*B + 25*D <= 8000, name="Worker_Minutes_Constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Blue T-Shirts = {B.varValue}, Dark Blue T-Shirts = {D.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
