
import gurobipy as gp

# Create a new model
m = gp.Model("auto_manufacturing")

# Create decision variables
d = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="doors") # Doors are assumed to be continuously divisible
b = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bumpers")

# Set objective function
m.setObjective(200*d + 150*b, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*d + 10*b <= 3000, "machine_time")
m.addConstr(d <= 100, "door_limit")
m.addConstr(b <= 200, "bumper_limit")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Doors: {d.x}")
    print(f"Number of Bumpers: {b.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

