
from gurobipy import *

# Create a model
m = Model("Auto_Manufacturing")

# Define variables
doors = m.addVar(lb=0, ub=100, vtype=GRB.INTEGER, name="doors")
bumpers = m.addVar(lb=0, ub=200, vtype=GRB.INTEGER, name="bumpers")

# Set the objective function
m.setObjective(200*doors + 150*bumpers, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*doors + 10*bumpers <= 3000, "machine_time")
m.addConstr(doors <= 100, "max_doors")
m.addConstr(bumpers <= 200, "max_bumpers")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Doors: {doors.x}")
    print(f"Bumpers: {bumpers.x}")
    print(f"Maximum Profit: ${200*doors.x + 150*bumpers.x}")
else:
    print("No optimal solution found")
