
import gurobi

def solve_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    D = model.addVar(lb=0, ub=100, name="Doors")
    B = model.addVar(lb=0, ub=200, name="Bumpers")

    # Objective function: Maximize profit
    model.setObjective(200 * D + 150 * B, gurobi.GRB.MAXIMIZE)

    # Machine time constraint
    model.addConstraint(20 * D + 10 * B <= 3000)

    # Door and bumper production limits are already considered in the variable definitions

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Doors: {D.varValue}, Bumpers: {B.varValue}")
        print(f"Max Profit: ${200 * D.varValue + 150 * B.varValue}")
    else:
        print("No optimal solution found.")

solve_production_problem()
