
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("action_figure_shelves")

# Create decision variables
x = m.addVar(vtype=GRB.INTEGER, name="small_shelves")
y = m.addVar(vtype=GRB.INTEGER, name="large_shelves")

# Set objective function
m.setObjective(20*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 6*y <= 100, "space_constraint")
m.addConstr(50*x + 80*y <= 1250, "budget_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small shelves (x): {x.x}")
    print(f"Number of large shelves (y): {y.x}")
    print(f"Maximum number of action figures: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

