
from gurobipy import *

# Create a model
m = Model("Shelf_Optimization")

# Define the decision variables
x = m.addVar(vtype=GRB.INTEGER, name="small_shelves")
y = m.addVar(vtype=GRB.INTEGER, name="large_shelves")

# Set the objective function
m.setObjective(20*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 6*y <= 100, "space_constraint")
m.addConstr(50*x + 80*y <= 1250, "budget_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Buy {x.x} small shelves and {y.x} large shelves.")
    print(f"Maximum action figures that can be stored: {20*x.x + 30*y.x}")
else:
    print("No optimal solution found.")

