
import gurobi

def solve_shelf_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=0, name="small_shelves")  # number of small shelves
    y = model.addVar(lb=0, name="large_shelves")  # number of large shelves

    # Objective function: maximize the number of action figures
    model.setObjective(20*x + 30*y, gurobi.GRB.MAXIMIZE)

    # Space constraint: 3x + 6y <= 100
    model.addConstr(3*x + 6*y <= 100, name="space_constraint")

    # Budget constraint: 50x + 80y <= 1250
    model.addConstr(50*x + 80*y <= 1250, name="budget_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum number of action figures: {20*x.varValue + 30*y.varValue}")
    else:
        print("No optimal solution found")

solve_shelf_problem()
