
import gurobipy as gp

# Create a new model
m = gp.Model("telecom_optimization")

# Create decision variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="internet_installations")
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="tv_installations")

# Set objective function
m.setObjective(100*x + 120*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(60*x + 50*y <= 7000, "wiring_time")
m.addConstr(10*x + 20*y <= 4000, "box_installation_time")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Internet Installations: {x.x}")
    print(f"Number of TV Installations: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

