
from gurobipy import *

# Create a new model
m = Model("Telecom_Optimization")

# Define the decision variables
I = m.addVar(lb=0, vtype=GRB.INTEGER, name="Internet_Services")
T = m.addVar(lb=0, vtype=GRB.INTEGER, name="TV_Services")

# Set the objective function
m.setObjective(100*I + 120*T, GRB.MAXIMIZE)

# Add constraints
m.addConstr(60*I + 50*T <= 7000, "Wiring_Time_Constraint")
m.addConstr(10*I + 20*T <= 4000, "Box_Installation_Time_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Internet Services: {I.x}")
    print(f"TV Services: {T.x}")
    print(f"Maximum Profit: ${100*I.x + 120*T.x:.2f}")
else:
    print("No optimal solution found")
