
import gurobipy as gp

# Create a new model
m = gp.Model("Telecom_Service_Installation")

# Define the decision variables
x = m.addVar(name="internet_services", lb=0, vtype=gp.GRB.INTEGER)
y = m.addVar(name="tv_services", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(100*x + 120*y, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(60*x + 50*y <= 7000, name="wiring_time_constraint")
m.addConstr(10*x + 20*y <= 4000, name="box_installation_time_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
    print(f"Maximum profit: ${100*x.varValue + 120*y.varValue}")
else:
    print("No optimal solution found")
