
from gurobipy import Model, GRB

# Create a new model
m = Model("makeup_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="perfume")
y = m.addVar(vtype=GRB.INTEGER, name="mascara")

# Set objective
m.setObjective(20*x + 15*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 40*y <= 20000, "budget")
m.addConstr(x >= 20, "perfume_min")
m.addConstr(x <= 40, "perfume_max")
m.addConstr(y <= (1/3)*x, "mascara_limit")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: {m.objVal}")
    print(f"Perfume Bottles: {x.x}")
    print(f"Mascara Bottles: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

