
from gurobipy import *

# Create a model
m = Model("Makeup_Store_Optimization")

# Decision variables
x = m.addVar(lb=20, ub=40, vtype=GRB.INTEGER, name="Perfume")
y = m.addVar(vtype=GRB.INTEGER, name="Mascara")

# Objective function: Maximize profit
m.setObjective(20*x + 15*y, GRB.MAXIMIZE)

# Constraints
m.addConstr(50*x + 40*y <= 20000, "Budget_Constraint")
m.addConstr(y <= (1/3)*x, "Mascara_Sales_Constraint")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Perfume to buy and sell: {x.x}")
    print(f"Mascara to buy and sell: {y.x}")
    print(f"Maximum profit: ${20*x.x + 15*y.x}")
else:
    print("No optimal solution found")
