
import gurobi

def solve_makeup_store_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(lb=0, ub=40, name="perfume")
    y = model.addVar(lb=0, name="mascara")

    # Set objective function
    model.setObjective(20 * x + 15 * y, gurobi.GRB.MAXIMIZE)

    # Add budget constraint
    model.addConstr(50 * x + 40 * y <= 20000, name="budget")

    # Add perfume sales constraint
    model.addConstr(x >= 20, name="perfume_min")
    model.addConstr(x <= 40, name="perfume_max")

    # Add mascara sales constraint
    model.addConstr(y <= x / 3, name="mascara_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of bottles of perfume to buy and sell: {x.varValue}")
        print(f"Number of bottles of mascara to buy and sell: {y.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_makeup_store_problem()
