
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("toothpaste_investment")

    # Create variables
    x = m.addVar(name="x") # Investment in company A
    y = m.addVar(name="y") # Investment in company B

    # Set objective function
    m.setObjective(0.12*x + 0.14*y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 5000, "Total_investment")
    m.addConstr(x >= 0.4 * (x + y), "Min_investment_A")
    m.addConstr(y >= 1000, "Min_investment_B")
    m.addConstr(x >=0)
    m.addConstr(y >=0)


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal investment in Company A: ${x.x:.2f}")
        print(f"Optimal investment in Company B: ${y.x:.2f}")
        print(f"Maximum profit: ${m.objVal:.2f}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
