
from gurobipy import *

# Create a new model
m = Model("Toothpaste_Investment")

# Define variables
x_A = m.addVar(lb=0, name="Investment_in_A")
x_B = m.addVar(lb=0, name="Investment_in_B")

# Set the objective function: Maximize profit
m.setObjective(0.12*x_A + 0.14*x_B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_A + x_B <= 5000, "Total_Investment")
m.addConstr(x_A >= 0.4*(x_A + x_B), "Minimum_Investment_in_A")
m.addConstr(x_B >= 1000, "Minimum_Investment_in_B")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal investment in Company A: $", round(x_A.x, 2))
    print("Optimal investment in Company B: $", round(x_B.x, 2))
    print("Maximum profit: $", round(m.objVal, 2))
else:
    print("Model is not optimal. Status:", m.status)

