
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_A = model.addVar(name="x_A", lb=0)  # Investment in A
    x_B = model.addVar(name="x_B", lb=0)  # Investment in B

    # Objective function: Maximize 0.12x_A + 0.14x_B
    model.setObjective(0.12 * x_A + 0.14 * x_B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_A + x_B <= 5000, name="total_investment")
    model.addConstr(x_B >= 1000, name="min_investment_B")
    model.addConstr(1.5 * x_A >= x_B, name="min_percentage_A")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in A: ${x_A.varValue:.2f}")
        print(f"Optimal investment in B: ${x_B.varValue:.2f}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_investment_problem()
