
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="gummy_vitamins")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="powder_vitamins")

# Set objective function
m.setObjective(1*x + 3*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 6*y >= 14, "vitamin_b_req")
m.addConstr(7*x + 2*y >= 24, "vitamin_d_req")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of gummy vitamins: {x.x:.2f}")
    print(f"Number of powder vitamins: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

