
from gurobipy import *

# Create a model
m = Model("Vitamin_Supplements")

# Define the decision variables
G = m.addVar(vtype=GRB.INTEGER, name="Gummy_Vitamins")
P = m.addVar(vtype=GRB.INTEGER, name="Powder_Vitamins")

# Set the objective function to minimize cost
m.setObjective(1*G + 3*P, GRB.MINIMIZE)

# Add constraints for vitamin requirements
m.addConstr(2*G + 6*P >= 14, name="Vitamin_B_Requirement")
m.addConstr(7*G + 2*P >= 24, name="Vitamin_D_Requirement")

# Optimize the model
m.optimize()

# Print out the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of gummy vitamins: {G.x}")
    print(f"Number of powder vitamins: {P.x}")
    print(f"Total cost: ${1*G.x + 3*P.x:.2f}")
else:
    print("No optimal solution found.")
