
import gurobi

def solve_vitamin_supplement_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="gummy_vitamins", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="powder_vitamins", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(1*x + 3*y, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2*x + 6*y >= 14, name="vitamin_B_requirement")
    model.addConstr(7*x + 2*y >= 24, name="vitamin_D_requirement")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_vitamin_supplement_problem()
