
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("ice_cream_production")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="maple_pecan")
y = m.addVar(vtype=GRB.CONTINUOUS, name="mint_chocolate")

# Set objective function
m.setObjective(400*x + 250*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(50*x + 30*y <= 8000, "mixing_constraint")
m.addConstr(80*x + 70*y <= 10000, "freezing_constraint")
m.addConstr(x >= 0, "maple_pecan_nonneg")
m.addConstr(y >= 0, "mint_choc_nonneg")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Maple Pecan Batches: {x.x}")
    print(f"Mint Chocolate Batches: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

